/**
 * BCL to FASTQ file converter
 * Copyright (c) 2007-2015 Illumina, Inc.
 *
 * This software is covered by the accompanying EULA
 * and certain third party copyright/licenses, and any user of this
 * source file is bound by the terms therein.
 *
 * \file Types.hh
 *
 * \brief Declaration of common data types
 *
 * \author Marek Balint
 */


#ifndef BCL2FASTQ_COMMON_TYPES_HH
#define BCL2FASTQ_COMMON_TYPES_HH


#include <cstddef>

#include <stdint.h>

#include <ostream>
#include "common/Debug.hh"

namespace bcl2fastq {


namespace common {

/// \brief Read type definition.
enum ReadType
{
    DATA,
    INDEX,
    UMI
};

/// \brief Lane number type definition.
typedef std::size_t LaneNumber;

/// \brief Sample number type definition.
typedef std::size_t SampleNumber;

/// \brief Tile number type definition.
typedef std::size_t TileNumber;

/// \brief Read number type definition.
typedef std::size_t ReadNumber;

/// \brief Cycle number type definition.
typedef std::size_t CycleNumber;

/// \brief Cycle number range.definition.
typedef std::pair<CycleNumber, CycleNumber> CycleRange;

/// \brief Number of clusters.
typedef uint32_t ClustersCount;

/// \brief Number of bases; throughput.
typedef uint64_t Yield;

/// \brief Number of bases; throughput.
typedef uint64_t QualityScore;

/// \brief Control flag type definition.
typedef uint16_t ControlFlag;

inline std::ostream& operator<<(std::ostream& os, ReadType readType)
{
    switch (readType)
    {
        case DATA:
            os << "data read";
            break;
        case INDEX:
            os << "index read";
            break;
        case UMI:
            os << "umi read";
            break;
        default:
            BCL2FASTQ_ASSERT_MSG(false, "Unrecognized ReadType");
        break;
    }

    return os;
}

} // namespace common


} // namespace bcl2fastq


#endif // BCL2FASTQ_DATA_TYPES_HH


