/**
 * BCL to FASTQ file converter
 * Copyright (c) 2007-2015 Illumina, Inc.
 *
 * This software is covered by the accompanying EULA
 * and certain third party copyright/licenses, and any user of this
 * source file is bound by the terms therein.
 *
 * \file FakeBclConsumer.hh
 *
 * \brief Declaration of fake BCL consumer.
 *
 * \author Marek Balint
 */


#ifndef BCL2FASTQ_CONVERSION_FAKEBCLCONSUMER_HH
#define BCL2FASTQ_CONVERSION_FAKEBCLCONSUMER_HH


#include "data/InteropFile.hh"
#include "layout/Layout.hh"
#include "layout/LaneInfo.hh"
#include "layout/BarcodeTranslationTable.hh"
#include "conversion/BclBuffer.hh"
#include "conversion/Stage.hh"
#include "conversion/Task.hh"


namespace bcl2fastq {


namespace conversion {


/// \brief Fake BCL consumer.
class FakeBclConsumer : public SinkStage<BclBuffer>
{
public:

    /// \brief Constructor.
    /// \param threadsCount Number of threads.
    /// \param inputMediator Input mediator.
    FakeBclConsumer(
        common::ThreadVector::size_type threadsCount,
        StageMediator<InputBuffer> &inputMediator
    );

public:

    virtual bool preExecute();

    virtual bool postExecute();
};


} // namespace conversion


} // namespace bcl2fastq


#endif // BCL2FASTQ_CONVERSION_FAKEBCLCONSUMER_HH


