/**
 * BCL to FASTQ file converter
 * Copyright (c) 2007-2015 Illumina, Inc.
 *
 * This software is covered by the accompanying EULA
 * and certain third party copyright/licenses, and any user of this
 * source file is bound by the terms therein.
 *
 * \file FakeBclConsumer.cpp
 *
 * \brief Implementation of fake BCL consumer.
 *
 * \author Marek Balint
 */


#include "conversion/FakeBclConsumer.hh"


namespace bcl2fastq {


namespace conversion {


FakeBclConsumer::FakeBclConsumer(
    common::ThreadVector::size_type threadsCount,
    StageMediator<InputBuffer> &inputMediator
)
: SinkStage<BclBuffer>(threadsCount, "Fake bcl consuming", inputMediator)
{
}


bool FakeBclConsumer::preExecute()
{
    return true;
}

bool FakeBclConsumer::postExecute()
{
    return true;
}


} // namespace conversion


} // namespace bcl2fastq


