/**
 * BCL to FASTQ file converter
 * Copyright (c) 2007-2015 Illumina, Inc.
 *
 * This software is covered by the accompanying EULA
 * and certain third party copyright/licenses, and any user of this
 * source file is bound by the terms therein.
 *
 * \file FastqBuffer.cpp
 *
 * \brief Implementation of FASTQ buffer.
 *
 * \author Marek Balint
 */


#include "conversion/FastqBuffer.hh"


namespace bcl2fastq {


namespace conversion {


void swap(FastqBuffer &lhs, FastqBuffer &rhs)
{
    using std::swap;
    swap(lhs.fastqs_, rhs.fastqs_);
}


} // namespace conversion


} // namespace bcl2fastq


