# DRAGEN Runner Scripts on ICA
These scripts present an API for CWL to run more complex on-node pipelines.  Scripts are written in Python 3.8, which is installed on top of the base DRAGEN image.  The entire `src` directory is copied onto `/python/` in the docker image.

## Overview
Most scripts pass unknown arguments directly to DRAGEN, only parsing arguments that need other work.  Modules can be separated into scripts with entry points, each containing its own argument parser, and shared modules with common functions used across different entry points.  Unit tests can be run using `pytest`.

### Entry Points
There are multiple entry scripts, depending on the tool.
- `batch_runner.py` runs one or multiple samples on a single node, sequentially.  DRAGEN arguments are static except for the sample input, i.e. `--fastqs` and `--bam-batch`
- `fastqc_runner.py` runs FASTQC followed by MultiQC in batch.
- `joint_runner.py` runs joint genotyping / calling.  Depending on the input type, small variant joint genotyping (GVCFs), CNV joint genotyping (.tn.tsv files), and SV joint calling (BAMs) may be enabled.
- `ref_builder.py` builds a DRAGEN hash table and archives it (using `tar`) for use with other pipelines.
- `somatic_runner.py` runs a tumor-normal analysis for a single sample.