from typing import List
from unittest.mock import MagicMock, patch

import fastqc_runner
from runner import ProcessCmd
from test_utils import assert_args


@patch('builtins.open')
def test_when_multiple_fastqs_passed__correctly_invokes_fastqc(mock_open):
    fastqc_runner.runner.run_dragen_cmds = MagicMock()
    fastqc_runner.execute_fastqc(['--foo', 'bar', '--baz', 'abc'], [
        '/my/folder/s01-NFE-CEX-NA12878_S1_L001_R1_001.fastq.gz',
        '/my/folder/s01-NFE-CEX-NA12878_S1_L001_R2_001.fastq.gz',
        '/my/folder/s01-NFE-CEX-NA12878_S1_L002_R1_001.fastq.gz',
        '/my/folder/s01-NFE-CEX-NA12878_S1_L002_R2_001.fastq.gz',
        '/my/folder/s02-NFE-CEX-NA12878_S13_L001_R1_001.fastq.gz',
        '/my/folder/s02-NFE-CEX-NA12878_S13_L001_R2_001.fastq.gz',
        '/my/folder/s02-NFE-CEX-NA12878_S13_L002_R1_001.fastq.gz',
        '/my/folder/s02-NFE-CEX-NA12878_S13_L002_R2_001.fastq.gz',
    ], 'all')

    cmds: List[ProcessCmd] = fastqc_runner.runner.run_dragen_cmds.call_args.args[0]
    assert len(cmds) == 4
    assert_args([
        '--output-directory .',
        '--foo bar ',
        '--baz abc',
        '--output-file-prefix s01-NFE-CEX-NA12878_S1',
        '--fastq-list-sample-id s01-NFE-CEX-NA12878_S1',
    ], cmds[1].cmd)
    assert_args([
        '--foo bar ',
        '--baz abc ',
        '--output-file-prefix s02-NFE-CEX-NA12878_S13',
        '--output-directory .',
        '--fastq-list-sample-id s02-NFE-CEX-NA12878_S13',
    ], cmds[2].cmd)
    assert cmds[3].cmd == 'multiqc -o . .'
