from typing import List
from unittest.mock import MagicMock

import joint_runner
from runner import ProcessCmd
from test_utils import assert_args


def test_when_gvcfs_and_tn_tsvs_passed__correctly_constructs_args():
    joint_runner.runner.run_dragen_cmds = MagicMock()
    joint_runner.execute_joint(
        '/my/ref.tar',
        ['--foo', 'bar'],
        ['/data/kid.gvcf.gz', '/data/mom.gvcf.gz', '/data/dad.gvcf.gz'],
        ['/cnv/kid.tn.tsv', '/cnv/mom.tn.tsv', '/cnv/dad.tn.tsv'],
        [],
        '--snv-option true',
        '--cnv-option false',
        None,
        None
    )
    cmds: List[ProcessCmd] = joint_runner.runner.run_dragen_cmds.call_args.args[0]
    assert cmds[1].cmd == 'tar -C /ephemeral/reference/index -xf /my/ref.tar'
    assert cmds[1].working_dir == '/ephemeral/reference/index'
    assert_args([
        '--output-directory .',
        '--foo bar',
        '--variant /data/kid.gvcf.gz',
        '--variant /data/mom.gvcf.gz',
        '--variant /data/dad.gvcf.gz',
        '--enable-joint-genotyping true',
        '--snv-option true',
    ], cmds[2].cmd)
    assert_args([
        '--foo bar',
        '--output-directory .',
        '--cnv-input /cnv/kid.tn.tsv',
        '--cnv-input /cnv/mom.tn.tsv',
        '--cnv-input /cnv/dad.tn.tsv',
        '--enable-cnv true',
        '--cnv-option false',
    ], cmds[3].cmd)


def test_when_bams_passed_in__correctly_constructs_args():
    joint_runner.runner.run_dragen_cmds = MagicMock()
    joint_runner.execute_joint(
        '/my/ref.tar',
        ['--foo', 'bar'],
        ['/data/kid.gvcf.gz', '/data/mom.gvcf.gz', '/data/dad.gvcf.gz'],
        ['/cnv/kid.tn.tsv', '/cnv/mom.tn.tsv', '/cnv/dad.tn.tsv'],
        ['/sv/kid.bam', '/sv/mom.bam', '/sv/dad.bam'],
        '--snv-option true',
        '--cnv-option false',
        '--enable-map-align false --sv-denovo-scoring true',
        'my.bed'
    )
    cmds: List[ProcessCmd] = joint_runner.runner.run_dragen_cmds.call_args.args[0]
    assert cmds[1].cmd == 'tar -C /ephemeral/reference/index -xf /my/ref.tar'
    assert cmds[1].working_dir == '/ephemeral/reference/index'
    assert_args([
        '--output-directory .',
        '--foo bar',
        '--variant /data/kid.gvcf.gz',
        '--variant /data/mom.gvcf.gz',
        '--variant /data/dad.gvcf.gz',
        '--enable-joint-genotyping true',
        '--snv-option true',
    ], cmds[2].cmd)
    assert '--sv-call-regions-bed' not in cmds[2].cmd

    assert_args([
        '--foo bar',
        '--output-directory .',
        '--cnv-input /cnv/kid.tn.tsv',
        '--cnv-input /cnv/mom.tn.tsv',
        '--cnv-input /cnv/dad.tn.tsv',
        '--enable-cnv true',
        '--cnv-option false',
    ], cmds[3].cmd)
    assert '--sv-call-regions-bed' not in cmds[3].cmd

    assert_args([
        '--foo bar',
        '--output-directory .',
        '--bam-input /sv/kid.bam',
        '--bam-input /sv/mom.bam',
        '--bam-input /sv/dad.bam',
        '--enable-sv true',
        '--sv-call-regions-bed my.bed',
        '--sv-denovo-scoring true',
        '--enable-map-align false'
    ], cmds[4].cmd)
