/**
 * BCL to FASTQ file converter
 * Copyright (c) 2007-2015 Illumina, Inc.
 *
 * This software is covered by the accompanying EULA
 * and certain third party copyright/licenses, and any user of this
 * source file is bound by the terms therein.
 *
 * \file FakeFastqProducer.hh
 *
 * \brief Declaration of fake FASTQ producer.
 *
 * \author Marek Balint
 */


#ifndef BCL2FASTQ_CONVERSION_FAKEFASTQPRODUCER_HH
#define BCL2FASTQ_CONVERSION_FAKEFASTQPRODUCER_HH


#include "layout/Layout.hh"
#include "conversion/BclBuffer.hh"
#include "conversion/FastqBuffer.hh"
#include "conversion/Stage.hh"
#include "conversion/Task.hh"


namespace bcl2fastq {


namespace conversion {


/// \brief FASTQ creator.
class FakeFastqProducer : public SourceStage<FastqBuffer>
{
public:

    /// \brief Constructor.
    /// \param threadsCount Number of threads.
    /// \param outputMediator Output mediator.
    /// \param layout Flowcell layout.
    /// \param laneInfo Lane meata data.
    /// \param createFastqsForIndexReads Create FASTQ files also for index reads flag.
    FakeFastqProducer(
        common::ThreadVector::size_type threadsCount,
        StageMediator<OutputBuffer> &outputMediator,
        const layout::Layout &layout,
        const layout::LaneInfo &laneInfo,
        bool createFastqsForIndexReads
    );

public:

    virtual bool preExecute();

    virtual bool postExecute();

private:

    /// \brief Layout.
    const layout::Layout &layout_;

    /// \brief Current lane.
    const layout::LaneInfo &laneInfo_;

    /// \brief Create FASTQ files also for index reads.
    bool createFastqsForIndexReads_;
};


} // namespace conversion


} // namespace bcl2fastq


#endif // BCL2FASTQ_CONVERSION_FAKEFASTQPRODUCER_HH


