/**
 * BCL to FASTQ file converter
 * Copyright (c) 2007-2015 Illumina, Inc.
 *
 * This software is covered by the accompanying EULA
 * and certain third party copyright/licenses, and any user of this
 * source file is bound by the terms therein.
 *
 * \file FastqBuffer.hh
 *
 * \brief Declaration of FASTQ buffer.
 *
 * \author Marek Balint
 */


#ifndef BCL2FASTQ_CONVERSION_FASTQBUFFER_HH
#define BCL2FASTQ_CONVERSION_FASTQBUFFER_HH


#include <vector>


namespace bcl2fastq {


namespace conversion {


/// \brief FASTQ buffer.
struct FastqBuffer
{
public:

    /// \brief FASTQ data container type definition.
    /// \note Container is indexed by sample, read and task
    /// (task is needed for parallelization).
    typedef std::vector<std::vector<std::vector<std::vector<char> > > > FastqsContainer;

public:

    /// \brief Buffers for FASTQ data.
    FastqsContainer fastqs_;
};


/// \brief Swap function for FASTQ buffer.
/// \param lhs Left-hand-side parameter.
/// \param rhs Right-hand-side parameter.
void swap(FastqBuffer &lhs, FastqBuffer &rhs);


} // namespace conversion


} // namespace bcl2fastq


#endif // BCL2FASTQ_CONVERSION_FASTQBUFFER_HH


