/**
 * BCL to FASTQ file converter
 * Copyright (c) 2007-2015 Illumina, Inc.
 *
 * This software is covered by the accompanying EULA
 * and certain third party copyright/licenses, and any user of this
 * source file is bound by the terms therein.
 *
 * \file TaskQueue.hh
 *
 * \brief Declaration of task queue.
 *
 * \author Marek Balint
 */


#ifndef BCL2FASTQ_CONVERSION_TASKQUEUE_HH
#define BCL2FASTQ_CONVERSION_TASKQUEUE_HH


#include <boost/ptr_container/ptr_vector.hpp>

#include "conversion/Task.hh"


namespace bcl2fastq {


namespace conversion {


/// \brief Task queue.
class TaskQueue : private boost::ptr_vector<Task>
{
public:

    typedef boost::ptr_vector<Task>::size_type size_type;

public:

    /// \brief Default constructor.
    TaskQueue();

public:

    /// \brief Add task.
    /// \param task Task to be added.
    /// \note Task queue assumes ownership of the task instance.
    void addTask(Task *task);

    /// \brief Get task.
    /// \return Task at the top of the queue.
    /// \note Ownership of the task is retained by the task queue throughout
    /// whole task's lifetime.
    Task * getTask();

    /// \brief Advance to the next task.
    /// \note Calling this function will merely advance internal pointer.
    /// It will not effect destroying any task instances.
    void advanceTask();

    /// \brief Get number of outstanding tasks.
    /// \return Number of outstanding tasks.
    TaskQueue::size_type getOutstandingTasksCount() const;

public:

    /// \brief Clear task queue.
    void clear();

private:

    /// \brief Current task.
    size_type currentTaskIndex_;
};


} // namespace conversion


} // namespace bcl2fastq


#endif // BCL2FASTQ_CONVERSION_TASKQUEUE_HH


