/**
 * BCL to FASTQ file converter
 * Copyright (c) 2007-2015 Illumina, Inc.
 *
 * This software is covered by the accompanying EULA
 * and certain third party copyright/licenses, and any user of this
 * source file is bound by the terms therein.
 *
 * \file BclBuffer.cpp
 *
 * \brief Implementation of BCL buffer.
 *
 * \author Marek Balint
 */


#include "conversion/BclBuffer.hh"


namespace bcl2fastq {


namespace conversion {


const BclBuffer::BclsContainer::value_type::size_type BclBuffer::clustersPerChunk_ = 4096*1024;  //8192*1024;


void swap(BclBuffer &lhs, BclBuffer &rhs)
{
    using std::swap;
    swap(lhs.bcls_, rhs.bcls_);
    swap(lhs.samples_, rhs.samples_);
    swap(lhs.tileInfo_, rhs.tileInfo_);
    swap(lhs.positions_, rhs.positions_);
    swap(lhs.filters_, rhs.filters_);
    swap(lhs.controls_, rhs.controls_);
}


} // namespace conversion


} // namespace bcl2fastq


