/**
 * BCL to FASTQ file converter
 * Copyright (c) 2007-2015 Illumina, Inc.
 *
 * This software is covered by the accompanying EULA
 * and certain third party copyright/licenses, and any user of this
 * source file is bound by the terms therein.
 *
 * \file Task.cpp
 *
 * \brief Implementation of a workload item a.k.a. task.
 *
 * \author Marek Balint
 */


#include "conversion/Task.hh"


namespace bcl2fastq {


namespace conversion {


Task::Task(bool stickyFlag)
: stickyFlag_(stickyFlag)
{
}

Task::~Task()
{
}

bool Task::isSticky() const
{
    return stickyFlag_;
}


SeparatorTask::SeparatorTask()
: Task(true)
{
}

bool SeparatorTask::execute(common::ThreadVector::size_type)
{
    // finish execution of current iteration on all threads that will
    // get to execute this task (i.e. all threads under normal circumstances)
    return false;
}


} // namespace task


} // namespace bcl2fastq


